from docplex.cp.model import *

from templates import *
from auxiliary import AuxiliaryStruct
from dbAPI import dbAPI
from RuleInsegnamento import *
from RuleDocente import *
from RulePenalty import *
from LocaliHandler import *
from RuleStudente import *
from Parameter import Parameter
from log import logger
from patterns import *
from utils import isSlotsOverlapped
from data.tables import *



class ConstraintBuilder(metaclass=SingletonMeta):
    def __init__(self, model:CpoModel, X_d, X_h):
        self.model:CpoModel = model
        
        self.X_d = X_d
        self.X_h = X_h
        
        self.AUX:AuxiliaryStruct = AuxiliaryStruct()
        self.dbAPI:dbAPI = dbAPI()
        self.PARAM = Parameter()
        self.log:logger = logger()
        
        self.RIH:RuleInsegnamentoHandler = RuleInsegnamentoHandler()
        self.RDH:RuleDocenteHandler = RuleDocenteHandler()
        self.LH:LocaliHandler = LocaliHandler()
        self.RSH:RuleStudenteHandler = RuleStudenteHandler(self.model)
        
        self.X_penaltiesStud = None
        self.X_penaltiesDoc = None
        
        self.stats:bool = True
                
        
    def addConstraint(self):
        self.log.info_log("\nconstraintBuilder.addConstraint(): creating hard constraint generici")
        
        ### MODEL BUILDING - Stage 1
                
        # generals
        equazioni = self.limitValues()
        
        # docenti
        # equazioni.extend(self.docenteInUnSoloInsegnamentoAllaVolta())
        
        # slot
        equazioni.extend(self.slotInsegnamentoNellaStessaGiornataConsecutivi())
        equazioni.extend(self.slotInsegnamentoNellaStessaGiornataNonSovrapposti())
        equazioni.extend(self.allocaSlotScelti())
        equazioni.extend(self.slotInsegnamentoGiornoDopoNonSubito())

        #aule
        self.log.info_log("\nconstraintBuilder.addConstraint(): creating constraint Locali")
        self.LH.createListsLocaliOfSlot()
        equazioni.extend(self.LH.model_addRules(self.X_d, self.X_h, self.model))
        
        self.model.add(equazioni)
        equazioni.clear()

        ### MODEL BUILDING - Stage 2
        
        # Constraint Orientamento -> self.X_penalties
        self.log.info_log("\nconstraintBuilder.addConstraint(): creating constraint Insegnamento")
        self.RIH.loadJson()
        self.RIH.prepareRules()
        self.insegnamentiOrientamentoSovrapposizioni()
        self.conflittiManualEsplciti()
        self.nVar_orientPenalties:int = self.RIH.finalizeRules()
        # self.RH.debug()
        if self.nVar_orientPenalties > 0:
            self.X_penalties = self.model.integer_var_list(self.nVar_orientPenalties, getIntFromLV_Penalties(LV_Penalties.LV_0, TipoPenalty.Orientamento), 
                                                    getIntFromLV_Penalties(LV_Penalties.LV_MAX, TipoPenalty.Orientamento), "penalty_orient")
        else:
            self.X_penalties = self.model.integer_var_list(0,0,0)
        equazioni.extend(self.RIH.model_AddRules(0, self.X_penalties, self.X_d, self.X_h))
        
        # Constraint Studenti -> self.X_penaltiesStud
        self.log.info_log("\nconstraintBuilder.addConstraint(): creating constraint Studente")
        equazioni.extend(self.RSH.model_AddRules_X_orient(self.X_d, self.X_h))
        equazioni.extend(self.RSH.model_AddRules_maxSlotOrientamentoPerDay(self.model))
        
        self.nVar_studPenalties = self.RSH.finalizeRules(self.model)
        if self.nVar_studPenalties > 0:
            self.X_penaltiesStud = self.model.integer_var_list(self.nVar_studPenalties, 
                                                    getIntFromLV_Penalties(LV_Penalties.LV_0, TipoPenalty.Studente),
                                                    getIntFromLV_Penalties(LV_Penalties.LV_MAX, TipoPenalty.Studente), "penalty_stud")
        else:
            self.X_penaltiesStud = self.model.integer_var_list(0,0,0)
        equazioni.extend(self.RSH.model_AddRules_X_penaltiesStud(0, self.X_penaltiesStud))
        
        
        # Constraint Docenti -> self.X_penaltiesDoc
        self.log.info_log("\nconstraintBuilder.addConstraint(): creating constraint Docente")
        self.RDH.loadJson()
        self.RDH.prepareRules()
        self.nVar_docPenalties:int = self.RDH.finalizeRules()
        if self.nVar_docPenalties > 0:
            self.X_penaltiesDoc = self.model.integer_var_list(self.nVar_docPenalties, 
                        (-1)*getIntFromLV_Penalties(LV_Penalties.LV_MAX, TipoPenalty.Docente), 
                        getIntFromLV_Penalties(LV_Penalties.LV_MAX, TipoPenalty.Docente), "penalty_doc")
        else:
            self.X_penaltiesDoc = self.model.integer_var_list(0,0,0)
        equazioni.extend(self.RDH.model_AddRules(0, self.X_penaltiesDoc, self.X_d, self.X_h, self.model))
            
      
        self.model.add(equazioni)
        return self.X_penalties, self.nVar_orientPenalties, self.X_penaltiesStud, self.nVar_studPenalties, self.X_penaltiesDoc, self.nVar_docPenalties


    def limitValues(self):
        '''Ogni slot può essere allocato solo in un giorno e ad un orario esistente'''   
        eqs = list()
        # lo slot può essere allocato solo se c'è tempo per allocarlo del tutto
        for slotId in self.AUX.map_strSlotId_to_idSlot.values():
            # serve settare almeno un vincolo per ogni variabile del modello, altrimenti non viene modellata
            eqs.append(self.X_h[slotId] >= 0) 
            
            if self.AUX.pianoAllocazione[slotId].numSlot > 1:
                # se lo slot è di un solo blocco non serve aggiungere nessun constraint
                eqs.append(self.X_h[slotId] <= self.AUX.NUM_SLOT_PER_DAY - self.AUX.pianoAllocazione[slotId].numSlot)
        
            if self.PARAM.sabatoEnabled:
                # il sabato ho meno slot allocabili
                eqs.append(if_then(self.X_d[slotId] == self.AUX.get_NUM_DAY()-1, 
                                   self.X_h[slotId]+self.AUX.pianoAllocazione[slotId].numSlot <= self.PARAM.nSlotSabato))
                
        return eqs
        
    def docenteInUnSoloInsegnamentoAllaVolta(self):
        '''dato un determinato slot, un docente può essere assegnato ad un solo insegnamento'''
        eqs = list()
        
        for docId in self.AUX.map_strDocenti_to_idDocenti.values():
            # per ogni docente
            for slotId_i in self.AUX.list_slotInDocente[docId]:
                for slotId_j in self.AUX.list_slotInDocente[docId]:
                    # se i due slot appartengono allo stesso docente -> non possono essere allocati contemporaneamente
                    if slotId_j > slotId_i: # as matrice triangolare (gli slotId sono ordinati)
                        eq = if_then(self.X_d[slotId_i] == self.X_d[slotId_j], 
                                logical_or(self.X_h[slotId_i] >= self.X_h[slotId_j] + self.AUX.pianoAllocazione[slotId_j].numSlot,
                                        self.X_h[slotId_j] >= self.X_h[slotId_i] + self.AUX.pianoAllocazione[slotId_i].numSlot))
                        eqs.append(eq)
        return eqs
    
    def slotInsegnamentoNellaStessaGiornataConsecutivi(self):
        '''se ho più Slot di un insegnamento nella stessa giornata e questi sono tenuti dallo stesso Docente => questi devono essere consecutivi.\n
        NB: questo non si applica in caso si slot di tipo EL (da spefiche definite).
        NBB: IMPONE ANCHE CHE SLOT DI UNO STESSO INSEGNAMENTO NON SI SOVRAPPONGANO'''
        eqs = list()
        
        # ogni giorno tutti gli slot appartenenti allo stesso insegnamento devono essere consecutivi 
        # i lab in realtà no -> non devo guardare tutti gli slot dell'insegnamento, ma solo quelli per
        # cui esiste in vincolo di consecutività (ie quelli non di laboratorio)
        self.log.info_log("Insegnamenti caricati:")
        for idInsegnamento in self.AUX.map_MetaInsegnamento_to_IdInsegnamento.values():
            # attivare per controllare quali Ins hanno ID_INC fallato
            self.log.info_log(self.AUX.list_Insegnamenti[idInsegnamento].ID_INC)             
            if int(self.AUX.list_Insegnamenti[idInsegnamento].ID_INC) < 0:
                continue
            
            # per ogni insegnamento
            for slotId_i in self.AUX.list_slotInInsegnamento[idInsegnamento]:
                for slotId_j in self.AUX.list_slotInInsegnamento[idInsegnamento]:
                    if slotId_i > slotId_j:
                        # se gli Slot non sono di tipo EL
                        if self.AUX.pianoAllocazione[slotId_i].tipoLezione == TipoLezione.EsercitazioneLaboratorio or self.AUX.pianoAllocazione[slotId_j].tipoLezione == TipoLezione.EsercitazioneLaboratorio:
                            continue
                        
                        # se non c'è nessun Docente in comune tra i 2 slot (sebbene i due Slot appartengano allo stesso Insegnamento) i due Slot
                        # non dovranno essere sovrapposti (vedi slotInsegnamentoNellaStessaGiornataNonSovrapposti()), ma non è necessario
                        # che siano consecutivi
                        intersez:bool = False
                        for doc_i in self.AUX.list_docentiInSlot[slotId_i]:
                            if doc_i in self.AUX.list_docentiInSlot[slotId_j]:
                                intersez = True
                        if not intersez: 
                            continue
                        
                        eq = if_then(self.X_d[slotId_i] == self.X_d[slotId_j],
                                logical_or(self.X_h[slotId_i] == self.X_h[slotId_j] + self.AUX.pianoAllocazione[slotId_j].numSlot,
                                           self.X_h[slotId_j] == self.X_h[slotId_i] + self.AUX.pianoAllocazione[slotId_i].numSlot))
                        eqs.append(eq)
        return eqs
    
    def slotInsegnamentoGiornoDopoNonSubito(self):
        '''Se uno Slot di un Insegnamento termina alle 19.00 di un giorno X => il giorno X+1 non potrà esserci uno slot di tale
        Insegnamento elle 8.30'''
        eqs = list()
        
        for idInsegnamento in self.AUX.map_MetaInsegnamento_to_IdInsegnamento.values():
            if int(self.AUX.list_Insegnamenti[idInsegnamento].ID_INC) < 0:
                continue
            
            # per ogni insegnamento
            for slotId_i in self.AUX.list_slotInInsegnamento[idInsegnamento]:
                for slotId_j in self.AUX.list_slotInInsegnamento[idInsegnamento]:
                    
                    if self.AUX.pianoAllocazione[slotId_i].tipoSlot == TipoSlot.SlotScelto and self.AUX.pianoAllocazione[slotId_j].tipoSlot == TipoSlot.SlotScelto:
                        continue
                    
                    if self.AUX.pianoAllocazione[slotId_i].tipoLezione == TipoLezione.EsercitazioneLaboratorio or self.AUX.pianoAllocazione[slotId_j].tipoLezione == TipoLezione.EsercitazioneLaboratorio:
                        continue
                    
                    if self.AUX.pianoAllocazione[slotId_i].squadra != Squadra.NoSquadra or self.AUX.pianoAllocazione[slotId_j].squadra != Squadra.NoSquadra:
                        continue
                    
                    if slotId_i > slotId_j:                        
                        
                        eq1 = if_then(
                            logical_and(self.X_d[slotId_i]+1 == self.X_d[slotId_j],
                                        self.X_h[slotId_j]+self.AUX.pianoAllocazione[slotId_j].numSlot == 7),
                                self.X_h[slotId_i] > 0)
                        
                        eq2 = if_then(
                            logical_and(self.X_d[slotId_j]+1 == self.X_d[slotId_i],
                                        self.X_h[slotId_i]+self.AUX.pianoAllocazione[slotId_i].numSlot == 7),
                                self.X_h[slotId_j] > 0)
                            
                        eqs.extend([eq1, eq2])
        return eqs
    
    def slotInsegnamentoNellaStessaGiornataNonSovrapposti(self):
        '''Si applica solo quando UNO degli slot è di tipo EL e/o gli Slot appartengono a Docenti diversi.\n
        Se i due slot sono di squadre diverse questi si possono allocare in parallelo.'''
        eqs = list()
        
        for idInsegnamento in self.AUX.map_MetaInsegnamento_to_IdInsegnamento.values():
            if int(self.AUX.list_Insegnamenti[idInsegnamento].ID_INC) < 0:
                continue
            
            # per ogni insegnamento
            for slotId_i in self.AUX.list_slotInInsegnamento[idInsegnamento]:
                for slotId_j in self.AUX.list_slotInInsegnamento[idInsegnamento]:
                    if slotId_i > slotId_j:                        
                        # se i due Slot hanno Docenti in comune => sono sicuramente consecutivi da self.slotInsegnamentoNellaStessaGiornataConsecutivi()
                        isIntersezioneDocenti:bool = False
                        for doc_i in self.AUX.list_docentiInSlot[slotId_i]:
                            if doc_i in self.AUX.list_docentiInSlot[slotId_j]:
                                isIntersezioneDocenti = True
                        
                        # se anche solo uno degli Slot non è a squadre => non posso allocare in parallelo
                        isSquadre:bool = (self.AUX.pianoAllocazione[slotId_i].squadra != Squadra.NoSquadra and self.AUX.pianoAllocazione[slotId_j].squadra != Squadra.NoSquadra)
                        
                        # se le squadre sono le stesse => non posso allocare in parallelo
                        isSameSquadra:bool = (self.AUX.pianoAllocazione[slotId_i].squadra == self.AUX.pianoAllocazione[slotId_j].squadra)
                        
                        # isUnoSlotDiLab:bool = (self.AUX.pianoAllocazione[slotId_i].tipoLezione == TipoLezione.EsercitazioneLaboratorio and self.AUX.pianoAllocazione[slotId_j].tipoLezione != TipoLezione.EsercitazioneLaboratorio) or (self.AUX.pianoAllocazione[slotId_j].tipoLezione == TipoLezione.EsercitazioneLaboratorio and self.AUX.pianoAllocazione[slotId_i].tipoLezione != TipoLezione.EsercitazioneLaboratorio)
                        
                        # Slot della stessa squadra o che non fanno riferimento a squadre non devono essere consecutivi
                        if isSquadre and not isSameSquadra:
                            continue
                        if not isIntersezioneDocenti:
                            eq = if_then(self.X_d[slotId_i] == self.X_d[slotId_j],
                                    logical_or(self.X_h[slotId_i] >= self.X_h[slotId_j] + self.AUX.pianoAllocazione[slotId_j].numSlot,
                                            self.X_h[slotId_j] >= self.X_h[slotId_i] + self.AUX.pianoAllocazione[slotId_i].numSlot))
                            eqs.append(eq)
                            

        return eqs
    
    def allocaSlotScelti(self):
        '''Alloco gli slot scelti come hard constraint.\n
        NOTE: gli Slot di Insegnamenti preallocati vengono trattati come se fossero SlotScelti (in caso si lavori in quella modalità)'''
        eqs = list()
    
        for slotId in self.AUX.map_strSlotId_to_idSlot.values():
            if self.AUX.pianoAllocazione[slotId].tipoSlot == TipoSlot.SlotScelto:                
                eqs.append(self.X_d[slotId] == self.AUX.pianoAllocazione[slotId].daySlotAllocato)
                eqs.append(self.X_h[slotId] == self.AUX.pianoAllocazione[slotId].hourSlotAllocato)
            elif self.AUX.pianoAllocazione[slotId].tipoSlot == TipoSlot.SlotScelto_fasciaOraria:
                eqs.append(self.X_h[slotId] == self.AUX.pianoAllocazione[slotId].hourSlotAllocato)
            elif self.AUX.pianoAllocazione[slotId].tipoSlot == TipoSlot.SlotScelto_giorno:
                eqs.append(self.X_d[slotId] == self.AUX.pianoAllocazione[slotId].daySlotAllocato)
                    
        return eqs
    
    def customCheckSlotParallelizzabili(self, slotId_i:str, slotId_j:str) -> bool:
        '''Controlla se due slot possono essere alloati in parallelo anche se secondo i normali requisiti non potrebbero'''
        
        # 259237 - Modeling and optimization of embedded systems Mar 14:30-17:30 pd: PeriodoDidattico.PrimoAnno_PrimoSemestre - 259236 - Electronics for embedded systems Mar 14:30-17:30 pd: PeriodoDidattico.PrimoAnno_PrimoSemestre
        if slotId_i in ["259237_slot_lab1", "259236_slot_lab2"] and slotId_j in ["259237_slot_lab1", "259236_slot_lab2"]:
            return True
        # 259922 - Statistical learning and neural networks Mar 11:30-14:30 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre - 259794 - Solid state physics/Electronic devices (modulo Electronic devices) Mar 13:00-14:30 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre
        if slotId_i in ["259794_slot1", "259922_slot_lab1"] and slotId_j in ["259794_slot1", "259922_slot_lab1"]:
            return True
        # 260160 - Signal Processing and Optical Transmission Lab Mar 14:30-19:00 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre pd: PeriodoDidattico.SecondoAnno_PrimoSemestre - 260159 - Signal Processing and Wireless Transmission Lab Mar 16:00-19:00 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre pd: PeriodoDidattico.SecondoAnno_PrimoSemestre
        if slotId_i in ["260160_slot_lab1", "260159_slot_lab1"] and slotId_j in ["260160_slot_lab1", "260159_slot_lab1"]:
            return True
        # 260160 - Signal Processing and Optical Transmission Lab Mar 14:30-19:00 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre pd: PeriodoDidattico.SecondoAnno_PrimoSemestre - 260159 - Signal Processing and Wireless Transmission Lab Mar 16:00-19:00 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre pd: PeriodoDidattico.SecondoAnno_PrimoSemestre
        if slotId_i in ["260160_slot_lab2", "260159_slot_lab2"] and slotId_j in ["260160_slot_lab2", "260159_slot_lab2"]:
            return True
        # 260302 - Cybersecurity Mar 14:30-17:30 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre - 260160 - Signal Processing and Optical Transmission Lab Mar 14:30-19:00 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre pd: PeriodoDidattico.SecondoAnno_PrimoSemestre
        if slotId_i in ["260302_slot2", "260160_slot_lab1"] and slotId_j in ["260302_slot2", "260160_slot_lab1"]:
            return True   
        # 260302 - Cybersecurity Mar 14:30-17:30 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre - 260159 - Signal Processing and Wireless Transmission Lab Mar 16:00-19:00 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre pd: PeriodoDidattico.SecondoAnno_PrimoSemestre
        if slotId_i in ["260302_slot2", "260159_slot_lab1"] and slotId_j in ["260302_slot2", "260159_slot_lab1"]:
            return True          
        # 260302 - Cybersecurity Ven 10:00-11:30 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre - 260158 - Open Optical Networks Ven 10:00-11:30 pd: PeriodoDidattico.SecondoAnno_PrimoSemestre 
        if slotId_i in ["260302_slot1", "260158_slot3"] and slotId_j in ["260302_slot1", "260158_slot3"]:
            return True    
                
        return False
                   
    def getInsegnamentoIdFromID_INC(self, ID_INC:int) -> int:
        for insId in range(len(self.AUX.list_Insegnamenti)):
            if self.AUX.list_Insegnamenti[insId].ID_INC == str(ID_INC):
                return insId
        self.log.error_log("constraintBuilder.getInsegnamentoIdFromID_INC(): ID_INC sconosciuto: {}".format(ID_INC))
        return -1
    
    def conflittiManualEsplciti(self) -> None:
        '''Aggiunge triple ID_INC1, ID_INC2, LV_penalità eventualmente non previsti dagli Orientamenti'''
        nSkip:int = 0
        nAddHard:int = 0
        nAddSoft:int = 0
        for item in list_InsegnamentiNonSovrapponibiliCustom:
            ID_INC1:int = item[0][0]
            ID_INC2:int = item[0][1]
            penalita:LV_Penalties = item[1]
            insId_i:int = self.getInsegnamentoIdFromID_INC(ID_INC1)
            insId_j:int = self.getInsegnamentoIdFromID_INC(ID_INC2)
            
            for slotId_i in self.AUX.list_slotInInsegnamento[insId_i]:
                for slotId_j in self.AUX.list_slotInInsegnamento[insId_j]:
                    
                    # no features: 2221 hard
                    # 2080 hard
                    # 1190 hard
                    
                    if self.AUX.pianoAllocazione[slotId_i].tipoSlot == TipoSlot.SlotScelto and self.AUX.pianoAllocazione[slotId_j].tipoSlot == TipoSlot.SlotScelto:
                        nSkip += 1
                        continue
                    
                    if self.AUX.pianoAllocazione[slotId_i].squadra == Squadra.Squadra_1 or self.AUX.pianoAllocazione[slotId_j].squadra == Squadra.Squadra_1 and penalita == LV_Penalties.LV_H:
                        nAddSoft += 1
                        rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_MAX)
                    else:
                        rule = RuleInsegnamento(slotId_i, slotId_j, penalita)
                        if penalita == LV_Penalties.LV_H:
                            nAddHard += 1
                        else:
                            nAddSoft += 1
                    self.RIH.addRule(rule)    
                    
        self.log.info_log("constraintBuilder.conflittiManualEsplciti(): nSkip: {}, nAddHard: {}, nAddSoft: {}".format(nSkip, nAddHard, nAddSoft))                
    
    def insegnamentiOrientamentoSovrapposizioni(self) -> None:
        '''i vari slotId appartenenti ai vari Insegnamenti di un Orientamento possono non dover essere sovrapposti
        come hard constraint o come soft constraint\n
        Return:
            nulla, lavora su self.RH\n'''        
         # print per ogni Orientamento tutti gli SlotScelti
        if self.stats:
            for orientId in self.AUX.map_Orientamento_to_IdOrientamento.values():
                listRes:List[str] = list()

                for periodoDidattico in [PeriodoDidattico.PrimoAnno_PrimoSemestre, PeriodoDidattico.SecondoAnno_PrimoSemestre, PeriodoDidattico.TerzoAnno_PrimoSemestre]:                
                    listRes = list()
                    listResInt:List[Tuple[Tuple[int,int],int]] = list() # ((day,hour),nSlot)
                    
                    for indexSlotId in range(len(self.AUX.list_slotIdInOrientamento[orientId])):
                        slotId = self.AUX.list_slotIdInOrientamento[orientId][indexSlotId]
                        if self.AUX.list_slotIdInOrientamento_tipo[orientId][indexSlotId] not in [TipoInsegnamento.Obbligatorio, TipoInsegnamento.ObbligatorioAScelta]:
                            continue
                        if self.AUX.list_slotIdInOrientamento_periodoDidattico[orientId][indexSlotId] != periodoDidattico:
                            continue
                        
                        if self.AUX.pianoAllocazione[slotId].tipoSlot == TipoSlot.SlotScelto:
                            res:str = self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId].idInsegnamento].ID_INC + " - " + self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId].idInsegnamento].titolo
                            res += " " + getSlotFromDayHour(self.AUX.pianoAllocazione[slotId].daySlotAllocato, self.AUX.pianoAllocazione[slotId].hourSlotAllocato, self.AUX.pianoAllocazione[slotId].numSlot)
                            for indexIns in range(len(self.AUX.list_InsegnamentiInOrientamento[orientId])):
                                insId = self.AUX.list_InsegnamentiInOrientamento[orientId][indexIns]
                                if slotId in self.AUX.list_slotInInsegnamento[insId]:
                                    res += " pd: " + str(self.AUX.list_InsegnamentiInOrientamento_periodoDidattico[orientId][indexIns])
                            listRes.append(res)
                            listResInt.append(((self.AUX.pianoAllocazione[slotId].daySlotAllocato, self.AUX.pianoAllocazione[slotId].hourSlotAllocato), self.AUX.pianoAllocazione[slotId].numSlot))
                        if self.AUX.pianoAllocazione[slotId].tipoSlot == TipoSlot.SlotScelto_giorno:
                            res:str = self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId].idInsegnamento].ID_INC + " - " + self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId].idInsegnamento].titolo
                            res += " " + getSlotFromDayHour(self.AUX.pianoAllocazione[slotId].daySlotAllocato, -1, self.AUX.pianoAllocazione[slotId].numSlot)
                            # listRes.append(res)
                        if self.AUX.pianoAllocazione[slotId].tipoSlot == TipoSlot.SlotScelto_fasciaOraria:
                            res:str = self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId].idInsegnamento].ID_INC + " - " + self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId].idInsegnamento].titolo
                            res += " " + getSlotFromDayHour(-1, self.AUX.pianoAllocazione[slotId].hourSlotAllocato, self.AUX.pianoAllocazione[slotId].numSlot)
                            # listRes.append(res) 
                   
                    if len(listRes) > 0:
                        self.log.info_log("\nSlot scelti Orientamento {} - {} - {} - {}".format(self.AUX.list_Orientamenti[orientId].nomeCdl,
                                    self.AUX.list_Orientamenti[orientId].orientamento, self.AUX.list_Orientamenti[orientId].tipoCdl,
                                    getStringFromPeriodoDidattico(periodoDidattico)))
                        for res in listRes:
                            self.log.info_log(res)         
                    setSovr:Set[str] = set()
                    for i in range(len(listRes)):
                            for j in range(len(listRes)):
                                if j > i:
                                    if isSlotsOverlapped(listResInt[i], listResInt[j]):
                                        setSovr.add(listRes[i])
                                        setSovr.add(listRes[j])
                    if len(setSovr) > 0:
                        self.log.info_logUtils("\nSlot scelti Orientamento {} - {} - {} - {}".format(self.AUX.list_Orientamenti[orientId].nomeCdl,
                                    self.AUX.list_Orientamenti[orientId].orientamento, self.AUX.list_Orientamenti[orientId].tipoCdl,
                                    getStringFromPeriodoDidattico(periodoDidattico)))
                        for res in setSovr:
                            self.log.info_logUtils(res)   
                                        
        for orientId in self.AUX.map_Orientamento_to_IdOrientamento.values():    
            # discorso matr triangolare per evitare di ripetere 2 volte lo stesso vincolo +            
            for index_i in range(len(self.AUX.list_slotIdInOrientamento[orientId])):
                for index_j in range(len(self.AUX.list_slotIdInOrientamento[orientId])):
                    # gli slotId presenti nelle liste non corrispondono alla pos nelle liste
                    # eg. dato un Orientamento (orientId = 0) -> list_slotIdInOrientamento[0] = [3,4,5] (3,4,5 sono slotID)
                    # -> devo accedere a list_slotIdInOrientamento_tipo[0][0,1,2] per trovare i corrispettivi tipi
                    # e non in 3,4,5
                    slotId_i = self.AUX.list_slotIdInOrientamento[orientId][index_i]
                    slotId_j = self.AUX.list_slotIdInOrientamento[orientId][index_j]
                                        
                    # se i due Slot appartengono ad anni differenti per l'Orientamento corrente non aggiungo nessun constraint
                    if not self.AUX.check_slotStessoAnno(index_i, index_j, orientId):
                        continue
                    
                    # se i due Slot sono parallelizzabili non aggiungo nessun constraint
                    if self.AUX.check_slotParallelizzabili(slotId_i, slotId_j):
                        continue
                    
                    # se i due Slot appartengono ad Alfabetiche differenti per l'Orientamento corrente non aggiungo nessun constraint
                    if self.AUX.check_slotAlfabeticheDiverse(index_i, index_j, orientId):
                        continue
                    
                    # se i due Slot appartengono ENTRAMBI ad Insegnamenti da considerare preallocati di default non devo generare nessun vincolo
                    if self.PARAM.usePianoAllocazioneAsBase:
                        if int(self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId_i].idInsegnamento].ID_INC) not in self.PARAM.listID_INCToModify and int(self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId_j].idInsegnamento].ID_INC) not in self.PARAM.listID_INCToModify:
                            self.log.info_log("ConstraintBuilder.insegnamentiOrientamentoSovrapposizioni(): skip Slot appartenenti a Insegnamenti: " + self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId_i].idInsegnamento].ID_INC + " e " + self.AUX.list_Insegnamenti[self.AUX.pianoAllocazione[slotId_j].idInsegnamento].ID_INC)
                            continue
                   
                    if self.customCheckSlotParallelizzabili(self.AUX.pianoAllocazione[slotId_i].slotId, self.AUX.pianoAllocazione[slotId_j].slotId):
                       continue
                   
                    if self.AUX.pianoAllocazione[slotId_i].squadra != Squadra.NoSquadra and self.AUX.pianoAllocazione[slotId_j].squadra != Squadra.NoSquadra and self.AUX.pianoAllocazione[slotId_i].squadra != self.AUX.pianoAllocazione[slotId_j].squadra:
                       continue
                                             
                    # gli slotId devono appartenere a corsi diversi (altrimenti il vincolo è già implementato)
                    if index_i > index_j and self.AUX.pianoAllocazione[slotId_i].idInsegnamento != self.AUX.pianoAllocazione[slotId_j].idInsegnamento:
                                                    
                        # Obbligatorio - Obbligatorio -> hard
                        if self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.Obbligatorio and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.Obbligatorio:
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_H)
                            self.RIH.addRule(rule)
                            
                        # Obbligatorio - ObbligatorioAScelta -> hard
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.ObbligatorioAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.Obbligatorio) or (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.ObbligatorioAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.Obbligatorio):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_H)
                            self.RIH.addRule(rule)
                            
                        # Obbligatorio - TabellaAScelta -> soft
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.TabellaAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.Obbligatorio) or (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.TabellaAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.Obbligatorio):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_4)
                            self.RIH.addRule(rule)
                                                        
                        # Obbligatorio - CreditoLibero -> soft
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.Obbligatorio) or (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.Obbligatorio):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_3)
                            self.RIH.addRule(rule)                            
  
                        # ObbligatorioAScelta - ObbligatorioAScelta -> hard
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.ObbligatorioAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.ObbligatorioAScelta):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_H)
                            self.RIH.addRule(rule)                                                   

                        # ObbligatorioAScelta - TabellaAScelta -> soft
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.TabellaAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.ObbligatorioAScelta) or (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.TabellaAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.ObbligatorioAScelta):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_4)
                            self.RIH.addRule(rule)
                            
                        # ObbligatorioAScelta - CreditoLibero -> soft
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.ObbligatorioAScelta) or (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.ObbligatorioAScelta):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_3)
                            self.RIH.addRule(rule)                            
                        
                        # TabellaAScelta - TabellaAScelta -> soft
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.TabellaAScelta and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.TabellaAScelta):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_2)
                            self.RIH.addRule(rule)
                            
                        # TabellaAScelta - CreditoLibero -> soft
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.TabellaAScelta) or (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.TabellaAScelta):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_1)
                            self.RIH.addRule(rule)
                        
                        # CreditoLibero - CreditoLibero -> soft (LV_0 -> in pratica non lo considero proprio)
                        elif (self.AUX.list_slotIdInOrientamento_tipo[orientId][index_i] == TipoInsegnamento.CreditoLibero and self.AUX.list_slotIdInOrientamento_tipo[orientId][index_j] == TipoInsegnamento.CreditoLibero):
                            rule = RuleInsegnamento(slotId_i, slotId_j, LV_Penalties.LV_0)
                            self.RIH.addRule(rule)
                